	clear all
	close all
	clc
	N = 7;
	wT0 = linspace(0, 0.2*pi, 10*N);	% Band of interest
	Tg0 = 2*N;						% Initial guess of the average group delay
	[G, Z, P, Tg0] = EQ_TG(Tg0, wT0, N)
	figure(1)
	PLOT_PZ_Z(Z, P)
	figure(2)
	subplot('position', [0.1 0.4 0.88 0.5]);
	wT = linspace(0, pi, 1000);
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	axis_Amax = 60; 	axis_Tg_max = 10;
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.3, 5.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(1.1, 5,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	abs(P)
	zoom on
	
